/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.glass.ui.Screen;
import com.sun.glass.utils.NativeLibLoader;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.font.AndroidFontFinder;
import com.sun.javafx.font.CompositeFontResource;
import com.sun.javafx.font.DFontDecoder;
import com.sun.javafx.font.FontConfigManager;
import com.sun.javafx.font.FontFactory;
import com.sun.javafx.font.FontFileWriter;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.LogicalFont;
import com.sun.javafx.font.MacFontFinder;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.font.PrismCompositeFontResource;
import com.sun.javafx.font.PrismFont;
import com.sun.javafx.font.PrismFontFile;
import com.sun.javafx.font.WindowsFontMap;
import com.sun.javafx.text.GlyphLayout;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;

public abstract class PrismFontFactory
implements FontFactory {
    public static final boolean debugFonts;
    public static final boolean isWindows;
    public static final boolean isLinux;
    public static final boolean isMacOSX;
    public static final boolean isIOS;
    public static final boolean isAndroid;
    public static final boolean isEmbedded;
    public static final int cacheLayoutSize;
    private static int subPixelMode;
    public static final int SUB_PIXEL_ON = 1;
    public static final int SUB_PIXEL_Y = 2;
    public static final int SUB_PIXEL_NATIVE = 4;
    private static float fontSizeLimit;
    private static boolean lcdEnabled;
    private static float lcdContrast;
    private static String jreFontDir;
    private static final String jreDefaultFont = "Lucida Sans Regular";
    private static final String jreDefaultFontLC = "lucida sans regular";
    private static final String jreDefaultFontFile = "LucidaSansRegular.ttf";
    private static final String CT_FACTORY = "com.sun.javafx.font.coretext.CTFactory";
    private static final String DW_FACTORY = "com.sun.javafx.font.directwrite.DWFactory";
    private static final String FT_FACTORY = "com.sun.javafx.font.freetype.FTFactory";
    HashMap<String, FontResource> fontResourceMap = new HashMap();
    HashMap<String, CompositeFontResource> compResourceMap = new HashMap();
    private static PrismFontFactory theFontFactory;
    private HashMap<String, PrismFontFile> fileNameToFontResourceMap = new HashMap();
    private ArrayList<WeakReference<PrismFontFile>> tmpFonts;
    private static final String[] STR_ARRAY;
    private volatile HashMap<String, String> fontToFileMap = null;
    private HashMap<String, String> fileToFontMap = null;
    private HashMap<String, String> fontToFamilyNameMap = null;
    private HashMap<String, ArrayList<String>> familyToFontListMap = null;
    private static String sysFontDir;
    private static String userFontDir;
    private static ArrayList<String> allFamilyNames;
    private static ArrayList<String> allFontNames;
    private static Thread fileCloser;
    private HashMap<String, PrismFontFile> embeddedFonts;
    private int numEmbeddedFonts = 0;
    private static float systemFontSize;
    private static String systemFontFamily;
    private static String monospaceFontFamily;

    private static String getNativeFactoryName() {
        if (isWindows) {
            return DW_FACTORY;
        }
        if (isMacOSX || isIOS) {
            return CT_FACTORY;
        }
        if (isLinux || isAndroid) {
            return FT_FACTORY;
        }
        return null;
    }

    public static float getFontSizeLimit() {
        return fontSizeLimit;
    }

    public static synchronized PrismFontFactory getFontFactory() {
        if (theFontFactory != null) {
            return theFontFactory;
        }
        String factoryClass = PrismFontFactory.getNativeFactoryName();
        if (factoryClass == null) {
            throw new InternalError("cannot find a native font factory");
        }
        if (debugFonts) {
            System.err.println("Loading FontFactory " + factoryClass);
            if (subPixelMode != 0) {
                String s = "Subpixel: enabled";
                if ((subPixelMode & 2) != 0) {
                    s = s + ", vertical";
                }
                if ((subPixelMode & 4) != 0) {
                    s = s + ", native";
                }
                System.err.println(s);
            }
        }
        if ((theFontFactory = PrismFontFactory.getFontFactory(factoryClass)) == null) {
            throw new InternalError("cannot load font factory: " + factoryClass);
        }
        return theFontFactory;
    }

    private static synchronized PrismFontFactory getFontFactory(String factoryClass) {
        try {
            Class<?> clazz = Class.forName(factoryClass);
            Method mid = clazz.getMethod("getFactory", null);
            return (PrismFontFactory)mid.invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            if (debugFonts) {
                System.err.println("Loading font factory failed " + factoryClass);
            }
            return null;
        }
    }

    protected abstract PrismFontFile createFontFile(String var1, String var2, int var3, boolean var4, boolean var5, boolean var6, boolean var7) throws Exception;

    public abstract GlyphLayout createGlyphLayout();

    private PrismFontFile createFontResource(String filename, int index) {
        return this.createFontResource(filename, index, true, false, false, false);
    }

    private PrismFontFile createFontResource(String filename, int index, boolean register, boolean embedded, boolean copy, boolean tracked) {
        String key = (filename + index).toLowerCase();
        PrismFontFile fr = this.fileNameToFontResourceMap.get(key);
        if (fr != null) {
            return fr;
        }
        try {
            fr = this.createFontFile(null, filename, index, register, embedded, copy, tracked);
            if (register) {
                this.storeInMap(fr.getFullName(), fr);
                this.fileNameToFontResourceMap.put(key, fr);
            }
            return fr;
        }
        catch (Exception e) {
            if (debugFonts) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private PrismFontFile createFontResource(String name, String filename) {
        return this.createFontResource(name, filename, true, false, false, false);
    }

    private PrismFontFile createFontResource(String name, String filename, boolean register, boolean embedded, boolean copy, boolean tracked) {
        if (filename == null) {
            return null;
        }
        String lcFN = filename.toLowerCase();
        if (lcFN.endsWith(".ttc")) {
            PrismFontFile fr;
            int index = 0;
            PrismFontFile namedFR = null;
            do {
                String key = (filename + index).toLowerCase();
                try {
                    fr = this.fileNameToFontResourceMap.get(key);
                    if (fr != null) {
                        if (!name.equals(fr.getFullName())) continue;
                        return fr;
                    }
                    fr = this.createFontFile(name, filename, index, register, embedded, copy, tracked);
                }
                catch (Exception e) {
                    if (debugFonts) {
                        e.printStackTrace();
                    }
                    return null;
                }
                String fontname = fr.getFullName();
                if (register) {
                    this.storeInMap(fontname, fr);
                    this.fileNameToFontResourceMap.put(key, fr);
                }
                if (index != 0 && !name.equals(fontname)) continue;
                namedFR = fr;
            } while (++index < fr.getFontCount());
            return namedFR;
        }
        return this.createFontResource(filename, 0, register, embedded, copy, tracked);
    }

    private String dotStyleStr(boolean bold, boolean italic) {
        if (!bold) {
            if (!italic) {
                return "";
            }
            return ".italic";
        }
        if (!italic) {
            return ".bold";
        }
        return ".bolditalic";
    }

    private void storeInMap(String name, FontResource resource) {
        if (name == null || resource == null) {
            return;
        }
        if (resource instanceof PrismCompositeFontResource) {
            System.err.println(name + " is a composite " + resource);
            Thread.dumpStack();
            return;
        }
        this.fontResourceMap.put(name.toLowerCase(), resource);
    }

    synchronized void addDecodedFont(PrismFontFile fr) {
        fr.setIsDecoded(true);
        this.addTmpFont(fr);
    }

    private synchronized void addTmpFont(PrismFontFile fr) {
        if (this.tmpFonts == null) {
            this.tmpFonts = new ArrayList();
        }
        WeakReference<PrismFontFile> ref = fr.isRegistered() ? new WeakReference<PrismFontFile>(fr) : fr.createFileDisposer(this);
        this.tmpFonts.add(ref);
        this.addFileCloserHook();
    }

    synchronized void removeTmpFont(WeakReference<PrismFontFile> ref) {
        if (this.tmpFonts != null) {
            this.tmpFonts.remove(ref);
        }
    }

    public synchronized FontResource getFontResource(String familyName, boolean bold, boolean italic, boolean wantComp) {
        int style;
        String fontFile;
        if (familyName == null || familyName.isEmpty()) {
            return null;
        }
        String lcFamilyName = familyName.toLowerCase();
        String styleStr = this.dotStyleStr(bold, italic);
        FontResource fr = this.lookupResource(lcFamilyName + styleStr, wantComp);
        if (fr != null) {
            return fr;
        }
        if (this.embeddedFonts != null && wantComp) {
            fr = this.lookupResource(lcFamilyName + styleStr, false);
            if (fr != null) {
                return new PrismCompositeFontResource(fr, lcFamilyName + styleStr);
            }
            for (PrismFontFile embeddedFont : this.embeddedFonts.values()) {
                String lcEmFamily = embeddedFont.getFamilyName().toLowerCase();
                if (!lcEmFamily.equals(lcFamilyName)) continue;
                return new PrismCompositeFontResource(embeddedFont, lcFamilyName + styleStr);
            }
        }
        if (isWindows && (fontFile = WindowsFontMap.findFontFile(lcFamilyName, style = (bold ? 1 : 0) + (italic ? 2 : 0))) != null && (fr = this.createFontResource(null, fontFile)) != null) {
            if (bold == fr.isBold() && italic == fr.isItalic() && !styleStr.isEmpty()) {
                this.storeInMap(lcFamilyName + styleStr, fr);
            }
            if (wantComp) {
                fr = new PrismCompositeFontResource(fr, lcFamilyName + styleStr);
            }
            return fr;
        }
        this.getFullNameToFileMap();
        ArrayList<String> family = this.familyToFontListMap.get(lcFamilyName);
        if (family == null) {
            return null;
        }
        FontResource plainFR = null;
        FontResource boldFR = null;
        FontResource italicFR = null;
        FontResource boldItalicFR = null;
        for (String fontName : family) {
            String lcFontName = fontName.toLowerCase();
            fr = this.fontResourceMap.get(lcFontName);
            if (fr == null) {
                String file = this.findFile(lcFontName);
                if (file != null) {
                    fr = this.getFontResource(fontName, file);
                }
                if (fr == null) continue;
                this.storeInMap(lcFontName, fr);
            }
            if (bold == fr.isBold() && italic == fr.isItalic()) {
                this.storeInMap(lcFamilyName + styleStr, fr);
                if (wantComp) {
                    fr = new PrismCompositeFontResource(fr, lcFamilyName + styleStr);
                }
                return fr;
            }
            if (!fr.isBold()) {
                if (!fr.isItalic()) {
                    plainFR = fr;
                    continue;
                }
                italicFR = fr;
                continue;
            }
            if (!fr.isItalic()) {
                boldFR = fr;
                continue;
            }
            boldItalicFR = fr;
        }
        fr = !bold && !italic ? (boldFR != null ? boldFR : (italicFR != null ? italicFR : boldItalicFR)) : (bold && !italic ? (plainFR != null ? plainFR : (boldItalicFR != null ? boldItalicFR : italicFR)) : (!bold && italic ? (boldItalicFR != null ? boldItalicFR : (plainFR != null ? plainFR : boldFR)) : (italicFR != null ? italicFR : (boldFR != null ? boldFR : plainFR))));
        if (fr != null) {
            this.storeInMap(lcFamilyName + styleStr, fr);
            if (wantComp) {
                fr = new PrismCompositeFontResource(fr, lcFamilyName + styleStr);
            }
        }
        return fr;
    }

    @Override
    public synchronized PGFont createFont(String familyName, boolean bold, boolean italic, float size) {
        FontResource fr = null;
        if (familyName != null && !familyName.isEmpty()) {
            PGFont logFont = LogicalFont.getLogicalFont(familyName, bold, italic, size);
            if (logFont != null) {
                return logFont;
            }
            fr = this.getFontResource(familyName, bold, italic, true);
        }
        if (fr == null) {
            return LogicalFont.getLogicalFont("System", bold, italic, size);
        }
        return new PrismFont(fr, fr.getFullName(), size);
    }

    @Override
    public synchronized PGFont createFont(String name, float size) {
        FontResource fr = null;
        if (name != null && !name.isEmpty()) {
            PGFont logFont = LogicalFont.getLogicalFont(name, size);
            if (logFont != null) {
                return logFont;
            }
            fr = this.getFontResource(name, null, true);
        }
        if (fr == null) {
            return LogicalFont.getLogicalFont("System Regular", size);
        }
        return new PrismFont(fr, fr.getFullName(), size);
    }

    private PrismFontFile getFontResource(String name, String file) {
        PrismFontFile fr = null;
        if (isMacOSX) {
            DFontDecoder decoder;
            block9: {
                decoder = null;
                if (name != null && file.endsWith(".dfont")) {
                    decoder = new DFontDecoder();
                    try {
                        decoder.openFile();
                        decoder.decode(name);
                        decoder.closeFile();
                        file = decoder.getFile().getPath();
                    }
                    catch (Exception e) {
                        file = null;
                        decoder.deleteFile();
                        decoder = null;
                        if (!debugFonts) break block9;
                        e.printStackTrace();
                    }
                }
            }
            if (file != null) {
                fr = this.createFontResource(name, file);
            }
            if (decoder != null) {
                if (fr != null) {
                    this.addDecodedFont(fr);
                } else {
                    decoder.deleteFile();
                }
            }
        } else {
            fr = this.createFontResource(name, file);
        }
        return fr;
    }

    @Override
    public synchronized PGFont deriveFont(PGFont font, boolean bold, boolean italic, float size) {
        FontResource fr = font.getFontResource();
        return new PrismFont(fr, fr.getFullName(), size);
    }

    private FontResource lookupResource(String lcName, boolean wantComp) {
        if (wantComp) {
            return this.compResourceMap.get(lcName);
        }
        return this.fontResourceMap.get(lcName);
    }

    public synchronized FontResource getFontResource(String name, String file, boolean wantComp) {
        String fontFile;
        String lcName;
        FontResource fr = null;
        if (name != null) {
            lcName = name.toLowerCase();
            FontResource fontResource = this.lookupResource(lcName, wantComp);
            if (fontResource != null) {
                return fontResource;
            }
            if (this.embeddedFonts != null && wantComp) {
                fr = this.lookupResource(lcName, false);
                if (fr != null) {
                    fr = new PrismCompositeFontResource(fr, lcName);
                }
                if (fr != null) {
                    return fr;
                }
            }
        }
        if (isWindows && name != null && (fontFile = WindowsFontMap.findFontFile(lcName = name.toLowerCase(), -1)) != null && (fr = this.createFontResource(null, fontFile)) != null) {
            if (wantComp) {
                fr = new PrismCompositeFontResource(fr, lcName);
            }
            return fr;
        }
        this.getFullNameToFileMap();
        if (name != null && file != null && (fr = this.getFontResource(name, file)) != null) {
            if (wantComp) {
                fr = new PrismCompositeFontResource(fr, name.toLowerCase());
            }
            return fr;
        }
        if (name != null && (fr = this.getFontResourceByFullName(name, wantComp)) != null) {
            return fr;
        }
        if (file != null && (fr = this.getFontResourceByFileName(file, wantComp)) != null) {
            return fr;
        }
        return null;
    }

    boolean isInstalledFont(String fileName) {
        String fileKey;
        if (isWindows) {
            if (fileName.toLowerCase().contains("\\windows\\fonts")) {
                return true;
            }
            File f = new File(fileName);
            fileKey = f.getName();
        } else {
            if (isMacOSX && fileName.toLowerCase().contains("/library/fonts")) {
                return true;
            }
            File f = new File(fileName);
            fileKey = f.getPath();
        }
        this.getFullNameToFileMap();
        return this.fileToFontMap.get(fileKey.toLowerCase()) != null;
    }

    private synchronized FontResource getFontResourceByFileName(String file, boolean wantComp) {
        if (this.fontToFileMap.size() <= 1) {
            return null;
        }
        String name = this.fileToFontMap.get(file.toLowerCase());
        FontResource fontResource = null;
        if (name == null) {
            fontResource = this.createFontResource(file, 0);
            if (fontResource != null) {
                String lcName = fontResource.getFullName().toLowerCase();
                this.storeInMap(lcName, fontResource);
                if (wantComp) {
                    fontResource = new PrismCompositeFontResource(fontResource, lcName);
                }
            }
        } else {
            String fullPath;
            String lcName = name.toLowerCase();
            fontResource = this.lookupResource(lcName, wantComp);
            if (fontResource == null && (fullPath = this.findFile(lcName)) != null) {
                fontResource = this.getFontResource(name, fullPath);
                if (fontResource != null) {
                    this.storeInMap(lcName, fontResource);
                }
                if (wantComp) {
                    fontResource = new PrismCompositeFontResource(fontResource, lcName);
                }
            }
        }
        return fontResource;
    }

    private synchronized FontResource getFontResourceByFullName(String name, boolean wantComp) {
        String lcName = name.toLowerCase();
        if (this.fontToFileMap.size() <= 1) {
            name = jreDefaultFont;
        }
        FontResource fontResource = null;
        String file = this.findFile(lcName);
        if (file != null && (fontResource = this.getFontResource(name, file)) != null) {
            this.storeInMap(lcName, fontResource);
            if (wantComp) {
                fontResource = new PrismCompositeFontResource(fontResource, lcName);
            }
        }
        return fontResource;
    }

    FontResource getDefaultFontResource(boolean wantComp) {
        FontResource fontResource = this.lookupResource(jreDefaultFontLC, wantComp);
        if (fontResource == null) {
            fontResource = this.createFontResource(jreDefaultFont, jreFontDir + jreDefaultFontFile);
            if (fontResource == null) {
                String path;
                String font;
                String file;
                Iterator<String> iterator = this.fontToFileMap.keySet().iterator();
                while (iterator.hasNext() && (fontResource = this.createFontResource(jreDefaultFontLC, file = this.findFile(font = iterator.next()))) == null) {
                }
                if (fontResource == null && isLinux && (path = FontConfigManager.getDefaultFontPath()) != null) {
                    fontResource = this.createFontResource(jreDefaultFontLC, path);
                }
                if (fontResource == null) {
                    return null;
                }
            }
            this.storeInMap(jreDefaultFontLC, fontResource);
            if (wantComp) {
                fontResource = new PrismCompositeFontResource(fontResource, jreDefaultFontLC);
            }
        }
        return fontResource;
    }

    private String findFile(String name) {
        if (name.equals(jreDefaultFontLC)) {
            return jreFontDir + jreDefaultFontFile;
        }
        this.getFullNameToFileMap();
        String filename = this.fontToFileMap.get(name);
        if (isWindows) {
            filename = PrismFontFactory.getPathNameWindows(filename);
        }
        return filename;
    }

    private static native byte[] getFontPath();

    private static native String regReadFontLink(String var0);

    private static native String getEUDCFontFile();

    private static void getPlatformFontDirs() {
        if (userFontDir != null || sysFontDir != null) {
            return;
        }
        byte[] pathBytes = PrismFontFactory.getFontPath();
        String path = new String(pathBytes);
        int scIdx = path.indexOf(59);
        if (scIdx < 0) {
            sysFontDir = path;
        } else {
            sysFontDir = path.substring(0, scIdx);
            userFontDir = path.substring(scIdx + 1, path.length());
        }
    }

    static ArrayList<String>[] getLinkedFonts(String searchFont, boolean addSearchFont) {
        String eudcFontFile;
        String fontRegBuf;
        ArrayList[] fontRegInfo = new ArrayList[]{new ArrayList(), new ArrayList()};
        if (isMacOSX) {
            fontRegInfo[0].add("/Library/Fonts/Arial Unicode.ttf");
            fontRegInfo[1].add("Arial Unicode MS");
            fontRegInfo[0].add(jreFontDir + jreDefaultFontFile);
            fontRegInfo[1].add(jreDefaultFont);
            fontRegInfo[0].add("/System/Library/Fonts/Apple Symbols.ttf");
            fontRegInfo[1].add("Apple Symbols");
            fontRegInfo[0].add("/System/Library/Fonts/STHeiti Light.ttf");
            fontRegInfo[1].add("Heiti SC Light");
            return fontRegInfo;
        }
        if (!isWindows) {
            return fontRegInfo;
        }
        if (addSearchFont) {
            fontRegInfo[0].add(null);
            fontRegInfo[1].add(searchFont);
        }
        if ((fontRegBuf = PrismFontFactory.regReadFontLink(searchFont)) != null && fontRegBuf.length() > 0) {
            String[] fontRegList = fontRegBuf.split("\u0000");
            int linkListLen = fontRegList.length;
            for (int i = 0; i < linkListLen; ++i) {
                String name;
                String[] splitFontData = fontRegList[i].split(",");
                int len = splitFontData.length;
                String file = PrismFontFactory.getPathNameWindows(splitFontData[0]);
                String string = name = len > 1 ? splitFontData[1] : null;
                if (name != null && fontRegInfo[1].contains(name) || name == null && fontRegInfo[0].contains(file)) continue;
                fontRegInfo[0].add(file);
                fontRegInfo[1].add(name);
            }
        }
        if ((eudcFontFile = PrismFontFactory.getEUDCFontFile()) != null) {
            fontRegInfo[0].add(eudcFontFile);
            fontRegInfo[1].add(null);
        }
        fontRegInfo[0].add(jreFontDir + jreDefaultFontFile);
        fontRegInfo[1].add(jreDefaultFont);
        if (PlatformUtil.isWinVistaOrLater()) {
            fontRegInfo[0].add(PrismFontFactory.getPathNameWindows("mingliub.ttc"));
            fontRegInfo[1].add("MingLiU-ExtB");
            if (PlatformUtil.isWin7OrLater()) {
                fontRegInfo[0].add(PrismFontFactory.getPathNameWindows("seguisym.ttf"));
                fontRegInfo[1].add("Segoe UI Symbol");
            } else {
                fontRegInfo[0].add(PrismFontFactory.getPathNameWindows("cambria.ttc"));
                fontRegInfo[1].add("Cambria Math");
            }
        }
        return fontRegInfo;
    }

    private void resolveWindowsFonts(HashMap<String, String> fontToFileMap, HashMap<String, String> fontToFamilyNameMap, HashMap<String, ArrayList<String>> familyToFontListMap) {
        ArrayList<String> unmappedFontNames = null;
        for (String font : fontToFamilyNameMap.keySet()) {
            Object file = fontToFileMap.get(font);
            if (file != null) continue;
            int dsi = font.indexOf("  ");
            if (dsi > 0) {
                String newName = font.substring(0, dsi);
                file = fontToFileMap.get(newName = newName.concat(font.substring(dsi + 1)));
                if (file == null || fontToFamilyNameMap.containsKey(newName)) continue;
                fontToFileMap.remove(newName);
                fontToFileMap.put(font, (String)file);
                continue;
            }
            if (font.equals("marlett")) {
                fontToFileMap.put(font, "marlett.ttf");
                continue;
            }
            if (font.equals("david")) {
                file = fontToFileMap.get("david regular");
                if (file == null) continue;
                fontToFileMap.remove("david regular");
                fontToFileMap.put("david", (String)file);
                continue;
            }
            if (unmappedFontNames == null) {
                unmappedFontNames = new ArrayList<String>();
            }
            unmappedFontNames.add(font);
        }
        if (unmappedFontNames != null) {
            HashSet<String> unmappedFontFiles = new HashSet<String>();
            HashMap<String, String> ffmapCopy = new HashMap<String, String>();
            ffmapCopy.putAll(fontToFileMap);
            for (String key : fontToFamilyNameMap.keySet()) {
                ffmapCopy.remove(key);
            }
            for (String key : ffmapCopy.keySet()) {
                unmappedFontFiles.add((String)ffmapCopy.get(key));
                fontToFileMap.remove(key);
            }
            this.resolveFontFiles(unmappedFontFiles, unmappedFontNames, fontToFileMap, fontToFamilyNameMap, familyToFontListMap);
            if (unmappedFontNames.size() > 0) {
                int sz = unmappedFontNames.size();
                for (int i = 0; i < sz; ++i) {
                    ArrayList<String> family;
                    String name = unmappedFontNames.get(i);
                    String familyName = fontToFamilyNameMap.get(name);
                    if (familyName != null && (family = familyToFontListMap.get(familyName)) != null && family.size() <= 1) {
                        familyToFontListMap.remove(familyName);
                    }
                    fontToFamilyNameMap.remove(name);
                }
            }
        }
    }

    private void resolveFontFiles(HashSet<String> unmappedFiles, ArrayList<String> unmappedFonts, HashMap<String, String> fontToFileMap, HashMap<String, String> fontToFamilyNameMap, HashMap<String, ArrayList<String>> familyToFontListMap) {
        for (String file : unmappedFiles) {
            try {
                PrismFontFile ttf;
                int fn = 0;
                String fullPath = PrismFontFactory.getPathNameWindows(file);
                while ((ttf = this.createFontResource(fullPath, fn++)) != null) {
                    String fontNameLC = ttf.getFullName().toLowerCase();
                    String localeNameLC = ttf.getLocaleFullName().toLowerCase();
                    if (unmappedFonts.contains(fontNameLC) || unmappedFonts.contains(localeNameLC)) {
                        fontToFileMap.put(fontNameLC, file);
                        unmappedFonts.remove(fontNameLC);
                        if (unmappedFonts.contains(localeNameLC)) {
                            unmappedFonts.remove(localeNameLC);
                            String family = ttf.getFamilyName();
                            String familyLC = family.toLowerCase();
                            fontToFamilyNameMap.remove(localeNameLC);
                            fontToFamilyNameMap.put(fontNameLC, family);
                            ArrayList<String> familylist = familyToFontListMap.get(familyLC);
                            if (familylist != null) {
                                familylist.remove(ttf.getLocaleFullName());
                            } else {
                                String localeFamilyLC = ttf.getLocaleFamilyName().toLowerCase();
                                familylist = familyToFontListMap.get(localeFamilyLC);
                                if (familylist != null) {
                                    familyToFontListMap.remove(localeFamilyLC);
                                }
                                familylist = new ArrayList();
                                familyToFontListMap.put(familyLC, familylist);
                            }
                            familylist.add(ttf.getFullName());
                        }
                    }
                    if (fn < ttf.getFontCount()) continue;
                }
            }
            catch (Exception e) {
                if (!debugFonts) continue;
                e.printStackTrace();
            }
        }
    }

    static native void populateFontFileNameMap(HashMap<String, String> var0, HashMap<String, String> var1, HashMap<String, ArrayList<String>> var2, Locale var3);

    static String getPathNameWindows(final String filename) {
        if (filename == null) {
            return null;
        }
        PrismFontFactory.getPlatformFontDirs();
        File f = new File(filename);
        if (f.isAbsolute()) {
            return filename;
        }
        if (userFontDir == null) {
            return sysFontDir + "\\" + filename;
        }
        String path = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                File f = new File(sysFontDir + "\\" + filename);
                if (f.exists()) {
                    return f.getAbsolutePath();
                }
                return userFontDir + "\\" + filename;
            }
        });
        if (path != null) {
            return path;
        }
        return null;
    }

    @Override
    public String[] getFontFamilyNames() {
        if (allFamilyNames == null) {
            ArrayList<String> familyNames = new ArrayList<String>();
            LogicalFont.addFamilies(familyNames);
            if (this.embeddedFonts != null) {
                for (PrismFontFile embeddedFont : this.embeddedFonts.values()) {
                    if (familyNames.contains(embeddedFont.getFamilyName())) continue;
                    familyNames.add(embeddedFont.getFamilyName());
                }
            }
            this.getFullNameToFileMap();
            for (String f : this.fontToFamilyNameMap.values()) {
                if (familyNames.contains(f)) continue;
                familyNames.add(f);
            }
            Collections.sort(familyNames);
            allFamilyNames = new ArrayList<String>(familyNames);
        }
        return allFamilyNames.toArray(STR_ARRAY);
    }

    @Override
    public String[] getFontFullNames() {
        if (allFontNames == null) {
            ArrayList<String> fontNames = new ArrayList<String>();
            LogicalFont.addFullNames(fontNames);
            if (this.embeddedFonts != null) {
                for (PrismFontFile prismFontFile : this.embeddedFonts.values()) {
                    if (fontNames.contains(prismFontFile.getFullName())) continue;
                    fontNames.add(prismFontFile.getFullName());
                }
            }
            this.getFullNameToFileMap();
            for (ArrayList arrayList : this.familyToFontListMap.values()) {
                for (String s : arrayList) {
                    fontNames.add(s);
                }
            }
            Collections.sort(fontNames);
            allFontNames = fontNames;
        }
        return allFontNames.toArray(STR_ARRAY);
    }

    @Override
    public String[] getFontFullNames(String family) {
        String[] logFonts = LogicalFont.getFontsInFamily(family);
        if (logFonts != null) {
            return logFonts;
        }
        if (this.embeddedFonts != null) {
            ArrayList<String> embeddedFamily = null;
            for (PrismFontFile embeddedFont : this.embeddedFonts.values()) {
                if (!embeddedFont.getFamilyName().equalsIgnoreCase(family)) continue;
                if (embeddedFamily == null) {
                    embeddedFamily = new ArrayList<String>();
                }
                embeddedFamily.add(embeddedFont.getFullName());
            }
            if (embeddedFamily != null) {
                return embeddedFamily.toArray(STR_ARRAY);
            }
        }
        this.getFullNameToFileMap();
        family = family.toLowerCase();
        ArrayList<String> familyFonts = this.familyToFontListMap.get(family);
        if (familyFonts != null) {
            return familyFonts.toArray(STR_ARRAY);
        }
        return STR_ARRAY;
    }

    public final int getSubPixelMode() {
        return subPixelMode;
    }

    public boolean isLCDTextSupported() {
        return lcdEnabled;
    }

    @Override
    public boolean isPlatformFont(String name) {
        if (name == null) {
            return false;
        }
        String lcName = name.toLowerCase();
        if (LogicalFont.isLogicalFont(lcName)) {
            return true;
        }
        if (lcName.startsWith("lucida sans")) {
            return true;
        }
        String systemFamily = PrismFontFactory.getSystemFont("System").toLowerCase();
        return lcName.startsWith(systemFamily);
    }

    public static boolean isJreFont(FontResource fr) {
        String file = fr.getFileName();
        return file.startsWith(jreFontDir);
    }

    public static float getLCDContrast() {
        if (lcdContrast == -1.0f) {
            lcdContrast = isWindows ? (float)PrismFontFactory.getLCDContrastWin32() / 1000.0f : 1.3f;
        }
        return lcdContrast;
    }

    private synchronized void addFileCloserHook() {
        if (fileCloser == null) {
            Runnable fileCloserRunnable = () -> {
                if (this.embeddedFonts != null) {
                    for (PrismFontFile prismFontFile : this.embeddedFonts.values()) {
                        prismFontFile.disposeOnShutdown();
                    }
                }
                if (this.tmpFonts != null) {
                    for (WeakReference weakReference : this.tmpFonts) {
                        PrismFontFile font = (PrismFontFile)weakReference.get();
                        if (font == null) continue;
                        font.disposeOnShutdown();
                    }
                }
            };
            AccessController.doPrivileged(() -> {
                ThreadGroup tg;
                ThreadGroup tgn = tg = Thread.currentThread().getThreadGroup();
                while (tgn != null) {
                    tg = tgn;
                    tgn = tg.getParent();
                }
                fileCloser = new Thread(tg, fileCloserRunnable);
                fileCloser.setContextClassLoader(null);
                Runtime.getRuntime().addShutdownHook(fileCloser);
                return null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PGFont loadEmbeddedFont(String name, InputStream fontStream, float size, boolean register) {
        if (!this.hasPermission()) {
            return this.createFont("System Regular", size);
        }
        if (FontFileWriter.hasTempPermission()) {
            return this.loadEmbeddedFont0(name, fontStream, size, register);
        }
        FontFileWriter.FontTracker tracker = FontFileWriter.FontTracker.getTracker();
        boolean acquired = false;
        try {
            acquired = tracker.acquirePermit();
            if (!acquired) {
                PGFont pGFont = null;
                return pGFont;
            }
            PGFont pGFont = this.loadEmbeddedFont0(name, fontStream, size, register);
            return pGFont;
        }
        catch (InterruptedException e) {
            PGFont pGFont = null;
            return pGFont;
        }
        finally {
            if (acquired) {
                tracker.releasePermit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PGFont loadEmbeddedFont0(String name, InputStream fontStream, float size, boolean register) {
        PrismFontFile fr = null;
        FontFileWriter fontWriter = new FontFileWriter();
        try {
            int bytesRead;
            File tFile = fontWriter.openFile();
            byte[] buf = new byte[8192];
            while ((bytesRead = fontStream.read(buf)) >= 0) {
                fontWriter.writeBytes(buf, 0, bytesRead);
            }
            fontWriter.closeFile();
            fr = this.loadEmbeddedFont(name, tFile.getPath(), register, true, fontWriter.isTracking());
            if (fr != null && fr.isDecoded()) {
                fontWriter.deleteFile();
            }
            this.addFileCloserHook();
        }
        catch (Exception e) {
            fontWriter.deleteFile();
        }
        finally {
            if (fr == null) {
                fontWriter.deleteFile();
            }
        }
        if (fr != null) {
            if (size <= 0.0f) {
                size = PrismFontFactory.getSystemFontSize();
            }
            return new PrismFont(fr, fr.getFullName(), size);
        }
        return null;
    }

    @Override
    public PGFont loadEmbeddedFont(String name, String path, float size, boolean register) {
        if (!this.hasPermission()) {
            return this.createFont("System Regular", size);
        }
        this.addFileCloserHook();
        PrismFontFile fr = this.loadEmbeddedFont(name, path, register, false, false);
        if (fr != null) {
            if (size <= 0.0f) {
                size = PrismFontFactory.getSystemFontSize();
            }
            return new PrismFont(fr, fr.getFullName(), size);
        }
        return null;
    }

    private void removeEmbeddedFont(String name) {
        PrismFontFile font = this.embeddedFonts.get(name);
        if (font == null) {
            return;
        }
        this.embeddedFonts.remove(name);
        String lcName = name.toLowerCase();
        this.fontResourceMap.remove(lcName);
        this.compResourceMap.remove(lcName);
        Iterator<CompositeFontResource> fi = this.compResourceMap.values().iterator();
        while (fi.hasNext()) {
            CompositeFontResource compFont = fi.next();
            if (compFont.getSlotResource(0) != font) continue;
            fi.remove();
        }
    }

    protected boolean registerEmbeddedFont(String path) {
        return true;
    }

    public int test_getNumEmbeddedFonts() {
        return this.numEmbeddedFonts;
    }

    private synchronized PrismFontFile loadEmbeddedFont(String name, String path, boolean register, boolean copy, boolean tracked) {
        FontResource resource;
        ++this.numEmbeddedFonts;
        PrismFontFile fr = this.createFontResource(name, path, register, true, copy, tracked);
        if (fr == null) {
            return null;
        }
        String family = fr.getFamilyName();
        if (family == null || family.length() == 0) {
            return null;
        }
        String fullname = fr.getFullName();
        if (fullname == null || fullname.length() == 0) {
            return null;
        }
        String psname = fr.getPSName();
        if (psname == null || psname.length() == 0) {
            return null;
        }
        boolean registerEmbedded = true;
        if (this.embeddedFonts != null && (resource = (FontResource)this.embeddedFonts.get(fullname)) != null && fr.equals(resource)) {
            registerEmbedded = false;
        }
        if (registerEmbedded && !this.registerEmbeddedFont(fr.getFileName())) {
            return null;
        }
        if (!register) {
            if (copy && !fr.isDecoded()) {
                this.addTmpFont(fr);
            }
            return fr;
        }
        if (this.embeddedFonts == null) {
            this.embeddedFonts = new HashMap();
        }
        if (name != null && !name.isEmpty()) {
            this.embeddedFonts.put(name, fr);
            this.storeInMap(name, fr);
        }
        this.removeEmbeddedFont(fullname);
        this.embeddedFonts.put(fullname, fr);
        this.storeInMap(fullname, fr);
        family = family + this.dotStyleStr(fr.isBold(), fr.isItalic());
        this.storeInMap(family, fr);
        this.compResourceMap.remove(family.toLowerCase());
        return fr;
    }

    private void logFontInfo(String message, HashMap<String, String> fontToFileMap, HashMap<String, String> fontToFamilyNameMap, HashMap<String, ArrayList<String>> familyToFontListMap) {
        System.err.println(message);
        for (String keyName : fontToFileMap.keySet()) {
            System.err.println("font=" + keyName + " file=" + fontToFileMap.get(keyName));
        }
        for (String keyName : fontToFamilyNameMap.keySet()) {
            System.err.println("font=" + keyName + " family=" + fontToFamilyNameMap.get(keyName));
        }
        for (String keyName : familyToFontListMap.keySet()) {
            System.err.println("family=" + keyName + " fonts=" + familyToFontListMap.get(keyName));
        }
    }

    private synchronized HashMap<String, String> getFullNameToFileMap() {
        if (this.fontToFileMap == null) {
            HashMap<String, String> tmpFontToFileMap = new HashMap<String, String>(100);
            this.fontToFamilyNameMap = new HashMap(100);
            this.familyToFontListMap = new HashMap(50);
            this.fileToFontMap = new HashMap(100);
            if (isWindows) {
                PrismFontFactory.getPlatformFontDirs();
                PrismFontFactory.populateFontFileNameMap(tmpFontToFileMap, this.fontToFamilyNameMap, this.familyToFontListMap, Locale.ENGLISH);
                if (debugFonts) {
                    System.err.println("Windows Locale ID=" + PrismFontFactory.getSystemLCID());
                    this.logFontInfo(" *** WINDOWS FONTS BEFORE RESOLVING", tmpFontToFileMap, this.fontToFamilyNameMap, this.familyToFontListMap);
                }
                this.resolveWindowsFonts(tmpFontToFileMap, this.fontToFamilyNameMap, this.familyToFontListMap);
                if (debugFonts) {
                    this.logFontInfo(" *** WINDOWS FONTS AFTER RESOLVING", tmpFontToFileMap, this.fontToFamilyNameMap, this.familyToFontListMap);
                }
            } else if (isMacOSX || isIOS) {
                MacFontFinder.populateFontFileNameMap(tmpFontToFileMap, this.fontToFamilyNameMap, this.familyToFontListMap, Locale.ENGLISH);
            } else if (isLinux) {
                FontConfigManager.populateMaps(tmpFontToFileMap, this.fontToFamilyNameMap, this.familyToFontListMap, Locale.getDefault());
                if (debugFonts) {
                    this.logFontInfo(" *** FONTCONFIG LOCATED FONTS:", tmpFontToFileMap, this.fontToFamilyNameMap, this.familyToFontListMap);
                }
            } else if (isAndroid) {
                AndroidFontFinder.populateFontFileNameMap(tmpFontToFileMap, this.fontToFamilyNameMap, this.familyToFontListMap, Locale.ENGLISH);
            } else {
                this.fontToFileMap = tmpFontToFileMap;
                return this.fontToFileMap;
            }
            for (String font : tmpFontToFileMap.keySet()) {
                String file = tmpFontToFileMap.get(font);
                this.fileToFontMap.put(file.toLowerCase(), font);
            }
            this.fontToFileMap = tmpFontToFileMap;
            if (isAndroid) {
                this.populateFontFileNameMapGeneric(AndroidFontFinder.getSystemFontsDir());
            }
            this.populateFontFileNameMapGeneric(jreFontDir);
        }
        return this.fontToFileMap;
    }

    @Override
    public final boolean hasPermission() {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new AllPermission());
            }
            return true;
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    void addToMaps(PrismFontFile fr) {
        if (fr == null) {
            return;
        }
        String fullName = fr.getFullName();
        String familyName = fr.getFamilyName();
        if (fullName == null || familyName == null) {
            return;
        }
        String lcFullName = fullName.toLowerCase();
        String lcFamilyName = familyName.toLowerCase();
        this.fontToFileMap.put(lcFullName, fr.getFileName());
        this.fontToFamilyNameMap.put(lcFullName, familyName);
        ArrayList<String> familyList = this.familyToFontListMap.get(lcFamilyName);
        if (familyList == null) {
            familyList = new ArrayList();
            this.familyToFontListMap.put(lcFamilyName, familyList);
        }
        familyList.add(fullName);
    }

    void populateFontFileNameMapGeneric(String fontDir) {
        File dir = new File(fontDir);
        String[] files = null;
        try {
            files = AccessController.doPrivileged(() -> dir.list(TTFilter.getInstance()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            try {
                PrismFontFile fr;
                String path = fontDir + File.separator + files[i];
                if (!this.registerEmbeddedFont(path)) continue;
                int index = 0;
                if ((fr = this.createFontResource(path, index++)) == null) continue;
                this.addToMaps(fr);
                while (index < fr.getFontCount() && (fr = this.createFontResource(path, index++)) != null) {
                    this.addToMaps(fr);
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static native int getLCDContrastWin32();

    private static native int getSystemFontSizeNative();

    private static native String getSystemFontNative();

    public static float getSystemFontSize() {
        if (systemFontSize == -1.0f) {
            if (isWindows) {
                float uiScale = Screen.getMainScreen().getUIScale();
                systemFontSize = (float)PrismFontFactory.getSystemFontSizeNative() / uiScale;
            } else if (isMacOSX || isIOS) {
                systemFontSize = MacFontFinder.getSystemFontSize();
            } else if (isAndroid) {
                systemFontSize = AndroidFontFinder.getSystemFontSize();
            } else if (isEmbedded) {
                try {
                    int screenDPI = Screen.getMainScreen().getResolutionY();
                    systemFontSize = (float)screenDPI / 6.0f;
                }
                catch (NullPointerException npe) {
                    systemFontSize = 13.0f;
                }
            } else {
                systemFontSize = 13.0f;
            }
        }
        return systemFontSize;
    }

    public static String getSystemFont(String name) {
        if (name.equals("System")) {
            if (systemFontFamily == null) {
                if (isWindows) {
                    systemFontFamily = PrismFontFactory.getSystemFontNative();
                    if (systemFontFamily == null) {
                        systemFontFamily = "Arial";
                    }
                } else if (isMacOSX || isIOS) {
                    systemFontFamily = MacFontFinder.getSystemFont();
                    if (systemFontFamily == null) {
                        systemFontFamily = "Lucida Grande";
                    }
                } else {
                    systemFontFamily = isAndroid ? AndroidFontFinder.getSystemFont() : "Lucida Sans";
                }
            }
            return systemFontFamily;
        }
        if (name.equals("SansSerif")) {
            return "Arial";
        }
        if (name.equals("Serif")) {
            return "Times New Roman";
        }
        if (monospaceFontFamily != null || isMacOSX) {
            // empty if block
        }
        if (monospaceFontFamily == null) {
            monospaceFontFamily = "Courier New";
        }
        return monospaceFontFamily;
    }

    static native short getSystemLCID();

    static {
        fontSizeLimit = 80.0f;
        lcdContrast = -1.0f;
        isWindows = PlatformUtil.isWindows();
        isMacOSX = PlatformUtil.isMac();
        isLinux = PlatformUtil.isLinux();
        isIOS = PlatformUtil.isIOS();
        isAndroid = PlatformUtil.isAndroid();
        isEmbedded = PlatformUtil.isEmbedded();
        int[] tempCacheLayoutSize = new int[]{65536};
        debugFonts = AccessController.doPrivileged(() -> {
            NativeLibLoader.loadLibrary("javafx_font");
            String dbg = System.getProperty("prism.debugfonts", "");
            boolean debug = "true".equals(dbg);
            jreFontDir = System.getProperty("java.home", "") + File.separator + "lib" + File.separator + "fonts" + File.separator;
            String s = System.getProperty("com.sun.javafx.fontSize");
            systemFontSize = -1.0f;
            if (s != null) {
                try {
                    systemFontSize = Float.parseFloat(s);
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Cannot parse font size '" + s + "'");
                }
            }
            if ((s = System.getProperty("prism.subpixeltext", "on")).indexOf("on") != -1 || s.indexOf("true") != -1) {
                subPixelMode = 1;
            }
            if (s.indexOf("native") != -1) {
                subPixelMode |= 5;
            }
            if (s.indexOf("vertical") != -1) {
                subPixelMode |= 7;
            }
            if ((s = System.getProperty("prism.fontSizeLimit")) != null) {
                try {
                    fontSizeLimit = Float.parseFloat(s);
                    if (fontSizeLimit <= 0.0f) {
                        fontSizeLimit = Float.POSITIVE_INFINITY;
                    }
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Cannot parse fontSizeLimit '" + s + "'");
                }
            }
            boolean lcdTextOff = isIOS || isAndroid || isEmbedded;
            String defLCDProp = lcdTextOff ? "false" : "true";
            String lcdProp = System.getProperty("prism.lcdtext", defLCDProp);
            lcdEnabled = lcdProp.equals("true");
            s = System.getProperty("prism.cacheLayoutSize");
            if (s != null) {
                try {
                    tempCacheLayoutSize[0] = Integer.parseInt(s);
                    if (tempCacheLayoutSize[0] < 0) {
                        tempCacheLayoutSize[0] = 0;
                    }
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Cannot parse cache layout size '" + s + "'");
                }
            }
            return debug;
        });
        cacheLayoutSize = tempCacheLayoutSize[0];
        theFontFactory = null;
        STR_ARRAY = new String[0];
        sysFontDir = null;
        userFontDir = null;
        fileCloser = null;
        systemFontFamily = null;
        monospaceFontFamily = null;
    }

    private static class TTFilter
    implements FilenameFilter {
        static TTFilter ttFilter;

        @Override
        public boolean accept(File dir, String name) {
            int offset = name.length() - 4;
            if (offset <= 0) {
                return false;
            }
            return name.startsWith(".ttf", offset) || name.startsWith(".TTF", offset) || name.startsWith(".ttc", offset) || name.startsWith(".TTC", offset) || name.startsWith(".otf", offset) || name.startsWith(".OTF", offset);
        }

        private TTFilter() {
        }

        static TTFilter getInstance() {
            if (ttFilter == null) {
                ttFilter = new TTFilter();
            }
            return ttFilter;
        }
    }
}

