/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.TwoLevelFocusComboBehavior;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.ArrayList;
import java.util.List;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class ComboBoxBaseBehavior<T>
extends BehaviorBase<ComboBoxBase<T>> {
    private TwoLevelFocusComboBehavior tlFocus;
    private KeyEvent lastEvent;
    private boolean keyDown;
    private static final String PRESS_ACTION = "Press";
    private static final String RELEASE_ACTION = "Release";
    protected static final List<KeyBinding> COMBO_BOX_BASE_BINDINGS = new ArrayList<KeyBinding>();
    private boolean showPopupOnMouseRelease = true;
    private boolean mouseInsideButton = false;

    public ComboBoxBaseBehavior(ComboBoxBase<T> comboBox, List<KeyBinding> bindings) {
        super(comboBox, bindings);
        if (Utils.isTwoLevelFocus()) {
            this.tlFocus = new TwoLevelFocusComboBehavior(comboBox);
        }
    }

    @Override
    public void dispose() {
        if (this.tlFocus != null) {
            this.tlFocus.dispose();
        }
        super.dispose();
    }

    @Override
    protected void focusChanged() {
        ComboBoxBase box = (ComboBoxBase)this.getControl();
        if (this.keyDown && !box.isFocused()) {
            this.keyDown = false;
            box.disarm();
        }
    }

    @Override
    protected void callActionForEvent(KeyEvent e) {
        this.lastEvent = e;
        this.showPopupOnMouseRelease = true;
        super.callActionForEvent(e);
    }

    @Override
    protected void callAction(String name) {
        if (PRESS_ACTION.equals(name)) {
            this.keyPressed();
        } else if (RELEASE_ACTION.equals(name)) {
            this.keyReleased();
        } else if ("showPopup".equals(name)) {
            this.show();
        } else if ("togglePopup".equals(name)) {
            if (((ComboBoxBase)this.getControl()).isShowing()) {
                this.hide();
            } else {
                this.show();
            }
        } else if ("Cancel".equals(name)) {
            this.cancelEdit(this.lastEvent);
        } else if ("ToParent".equals(name)) {
            this.forwardToParent(this.lastEvent);
        } else {
            super.callAction(name);
        }
    }

    private void keyPressed() {
        if (Utils.isTwoLevelFocus()) {
            this.show();
            if (this.tlFocus != null) {
                this.tlFocus.setExternalFocus(false);
            }
        } else if (!((ComboBoxBase)this.getControl()).isPressed() && !((ComboBoxBase)this.getControl()).isArmed()) {
            this.keyDown = true;
            ((ComboBoxBase)this.getControl()).arm();
        }
    }

    private void keyReleased() {
        if (!Utils.isTwoLevelFocus() && this.keyDown) {
            this.keyDown = false;
            if (((ComboBoxBase)this.getControl()).isArmed()) {
                ((ComboBoxBase)this.getControl()).disarm();
            }
        }
    }

    protected void forwardToParent(KeyEvent event) {
        if (((ComboBoxBase)this.getControl()).getParent() != null) {
            ((ComboBoxBase)this.getControl()).getParent().fireEvent(event);
        }
    }

    protected void cancelEdit(KeyEvent event) {
        ComboBoxBase comboBoxBase = (ComboBoxBase)this.getControl();
        TextField textField = null;
        if (comboBoxBase instanceof DatePicker) {
            textField = ((DatePicker)comboBoxBase).getEditor();
        } else if (comboBoxBase instanceof ComboBox) {
            TextField textField2 = textField = comboBoxBase.isEditable() ? ((ComboBox)comboBoxBase).getEditor() : null;
        }
        if (textField != null && textField.getTextFormatter() != null) {
            textField.cancelEdit();
        } else {
            this.forwardToParent(event);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.arm(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        this.disarm();
        if (this.showPopupOnMouseRelease) {
            this.show();
        } else {
            this.showPopupOnMouseRelease = true;
            this.hide();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        EventTarget target;
        super.mouseEntered(e);
        this.mouseInsideButton = !((ComboBoxBase)this.getControl()).isEditable() ? true : (target = e.getTarget()) instanceof Node && "arrow-button".equals(((Node)target).getId());
        this.arm();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        this.mouseInsideButton = false;
        this.disarm();
    }

    private void getFocus() {
        if (!((ComboBoxBase)this.getControl()).isFocused() && ((ComboBoxBase)this.getControl()).isFocusTraversable()) {
            ((ComboBoxBase)this.getControl()).requestFocus();
        }
    }

    private void arm(MouseEvent e) {
        boolean valid;
        boolean bl = valid = e.getButton() == MouseButton.PRIMARY && !e.isMiddleButtonDown() && !e.isSecondaryButtonDown() && !e.isShiftDown() && !e.isControlDown() && !e.isAltDown() && !e.isMetaDown();
        if (!((ComboBoxBase)this.getControl()).isArmed() && valid) {
            ((ComboBoxBase)this.getControl()).arm();
        }
    }

    public void show() {
        if (!((ComboBoxBase)this.getControl()).isShowing()) {
            ((ComboBoxBase)this.getControl()).requestFocus();
            ((ComboBoxBase)this.getControl()).show();
        }
    }

    public void hide() {
        if (((ComboBoxBase)this.getControl()).isShowing()) {
            ((ComboBoxBase)this.getControl()).hide();
        }
    }

    public void onAutoHide() {
        this.hide();
        this.showPopupOnMouseRelease = this.mouseInsideButton ? !this.showPopupOnMouseRelease : true;
    }

    public void arm() {
        if (((ComboBoxBase)this.getControl()).isPressed()) {
            ((ComboBoxBase)this.getControl()).arm();
        }
    }

    public void disarm() {
        if (!this.keyDown && ((ComboBoxBase)this.getControl()).isArmed()) {
            ((ComboBoxBase)this.getControl()).disarm();
        }
    }

    static {
        COMBO_BOX_BASE_BINDINGS.add(new KeyBinding(KeyCode.F4, KeyEvent.KEY_RELEASED, "togglePopup"));
        COMBO_BOX_BASE_BINDINGS.add(new KeyBinding(KeyCode.UP, "togglePopup").alt());
        COMBO_BOX_BASE_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "togglePopup").alt());
        COMBO_BOX_BASE_BINDINGS.add(new KeyBinding(KeyCode.SPACE, KeyEvent.KEY_PRESSED, PRESS_ACTION));
        COMBO_BOX_BASE_BINDINGS.add(new KeyBinding(KeyCode.SPACE, KeyEvent.KEY_RELEASED, RELEASE_ACTION));
        COMBO_BOX_BASE_BINDINGS.add(new KeyBinding(KeyCode.ENTER, KeyEvent.KEY_PRESSED, PRESS_ACTION));
        COMBO_BOX_BASE_BINDINGS.add(new KeyBinding(KeyCode.ENTER, KeyEvent.KEY_RELEASED, RELEASE_ACTION));
        COMBO_BOX_BASE_BINDINGS.add(new KeyBinding(KeyCode.ESCAPE, "Cancel"));
        COMBO_BOX_BASE_BINDINGS.add(new KeyBinding(KeyCode.F10, "ToParent"));
    }
}

