/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.mac;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import javafx.geometry.Bounds;

final class MacVariant {
    static final int NSArray_id = 1;
    static final int NSArray_NSString = 2;
    static final int NSArray_int = 3;
    static final int NSArray_range = 4;
    static final int NSAttributedString = 5;
    static final int NSData = 6;
    static final int NSDate = 7;
    static final int NSDictionary = 8;
    static final int NSNumber_Boolean = 9;
    static final int NSNumber_Int = 10;
    static final int NSNumber_Float = 11;
    static final int NSNumber_Double = 12;
    static final int NSString = 13;
    static final int NSURL = 14;
    static final int NSValue_point = 15;
    static final int NSValue_size = 16;
    static final int NSValue_rectangle = 17;
    static final int NSValue_range = 18;
    static final int NSObject = 19;
    int type;
    long[] longArray;
    int[] intArray;
    String[] stringArray;
    MacVariant[] variantArray;
    float float1;
    float float2;
    float float3;
    float float4;
    int int1;
    int int2;
    String string;
    long long1;
    double double1;
    int location;
    int length;
    long key;

    MacVariant() {
    }

    static MacVariant createNSArray(Object result) {
        MacVariant variant = new MacVariant();
        variant.type = 1;
        variant.longArray = (long[])result;
        return variant;
    }

    static MacVariant createNSObject(Object result) {
        MacVariant variant = new MacVariant();
        variant.type = 19;
        variant.long1 = (Long)result;
        return variant;
    }

    static MacVariant createNSString(Object result) {
        MacVariant variant = new MacVariant();
        variant.type = 13;
        variant.string = (String)result;
        return variant;
    }

    static MacVariant createNSAttributedString(Object result) {
        MacVariant variant = new MacVariant();
        variant.type = 5;
        variant.string = (String)result;
        return variant;
    }

    static MacVariant createNSDate(Object result) {
        MacVariant variant = new MacVariant();
        variant.type = 7;
        variant.long1 = ((LocalDate)result).atStartOfDay(ZoneId.systemDefault()).toEpochSecond();
        return variant;
    }

    static MacVariant createNSValueForSize(Object result) {
        Bounds bounds = (Bounds)result;
        MacVariant variant = new MacVariant();
        variant.type = 16;
        variant.float1 = (float)bounds.getWidth();
        variant.float2 = (float)bounds.getHeight();
        return variant;
    }

    static MacVariant createNSValueForPoint(Object result) {
        Bounds bounds = (Bounds)result;
        MacVariant variant = new MacVariant();
        variant.type = 15;
        variant.float1 = (float)bounds.getMinX();
        variant.float2 = (float)bounds.getMinY();
        return variant;
    }

    static MacVariant createNSValueForRectangle(Object result) {
        Bounds bounds = (Bounds)result;
        MacVariant variant = new MacVariant();
        variant.type = 17;
        variant.float1 = (float)bounds.getMinX();
        variant.float2 = (float)bounds.getMinY();
        variant.float3 = (float)bounds.getWidth();
        variant.float4 = (float)bounds.getHeight();
        return variant;
    }

    static MacVariant createNSValueForRange(Object result) {
        int[] range = (int[])result;
        MacVariant variant = new MacVariant();
        variant.type = 18;
        variant.int1 = range[0];
        variant.int2 = range[1];
        return variant;
    }

    static MacVariant createNSNumberForBoolean(Object result) {
        Boolean value = (Boolean)result;
        MacVariant variant = new MacVariant();
        variant.type = 9;
        variant.int1 = value != false ? 1 : 0;
        return variant;
    }

    static MacVariant createNSNumberForDouble(Object result) {
        MacVariant variant = new MacVariant();
        variant.type = 12;
        variant.double1 = (Double)result;
        return variant;
    }

    static MacVariant createNSNumberForInt(Object result) {
        MacVariant variant = new MacVariant();
        variant.type = 10;
        variant.int1 = (Integer)result;
        return variant;
    }

    Object getValue() {
        switch (this.type) {
            case 9: {
                return this.int1 != 0;
            }
            case 10: {
                return this.int1;
            }
            case 12: {
                return this.double1;
            }
            case 1: {
                return this.longArray;
            }
            case 3: {
                return this.intArray;
            }
            case 18: {
                return new int[]{this.int1, this.int2};
            }
            case 15: {
                return new float[]{this.float1, this.float2};
            }
            case 16: {
                return new float[]{this.float1, this.float2};
            }
            case 17: {
                return new float[]{this.float1, this.float2, this.float3, this.float4};
            }
            case 13: {
                return this.string;
            }
            case 5: {
                return this.string;
            }
        }
        return null;
    }

    public String toString() {
        Object v = this.getValue();
        switch (this.type) {
            case 1: {
                v = Arrays.toString((long[])v);
                break;
            }
            case 3: {
                v = Arrays.toString((int[])v);
                break;
            }
            case 18: {
                v = Arrays.toString((int[])v);
                break;
            }
            case 5: {
                v = v + Arrays.toString(this.variantArray);
                break;
            }
            case 8: {
                v = "keys: " + Arrays.toString(this.longArray) + " values: " + Arrays.toString(this.variantArray);
            }
        }
        return "MacVariant type: " + this.type + " value " + v;
    }
}

