/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.stage;

import java.security.AccessControlContext;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.stage.Screen;
import javafx.stage.Window;

public final class WindowHelper {
    private static WindowAccessor windowAccessor;

    private WindowHelper() {
    }

    public static void notifyLocationChanged(Window window, double x, double y) {
        windowAccessor.notifyLocationChanged(window, x, y);
    }

    public static void notifySizeChanged(Window window, double width, double height) {
        windowAccessor.notifySizeChanged(window, width, height);
    }

    static AccessControlContext getAccessControlContext(Window window) {
        return windowAccessor.getAccessControlContext(window);
    }

    public static void setWindowAccessor(WindowAccessor newAccessor) {
        if (windowAccessor != null) {
            throw new IllegalStateException();
        }
        windowAccessor = newAccessor;
    }

    public static WindowAccessor getWindowAccessor() {
        return windowAccessor;
    }

    private static void forceInit(Class<?> classToInit) {
        try {
            Class.forName(classToInit.getName(), true, classToInit.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        WindowHelper.forceInit(Window.class);
    }

    public static interface WindowAccessor {
        public void notifyLocationChanged(Window var1, double var2, double var4);

        public void notifySizeChanged(Window var1, double var2, double var4);

        public void notifyScreenChanged(Window var1, Object var2, Object var3);

        public float getUIScale(Window var1);

        public float getRenderScale(Window var1);

        public ReadOnlyObjectProperty<Screen> screenProperty(Window var1);

        public AccessControlContext getAccessControlContext(Window var1);
    }
}

