/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.dom;

import com.sun.webkit.Disposer;
import com.sun.webkit.DisposerRecord;
import com.sun.webkit.dom.NodeImpl;
import com.sun.webkit.dom.XPathResultImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.xpath.XPathExpression;
import org.w3c.dom.xpath.XPathResult;

public class XPathExpressionImpl
implements XPathExpression {
    private final long peer;

    XPathExpressionImpl(long peer) {
        this.peer = peer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static XPathExpression create(long peer) {
        if (peer == 0L) {
            return null;
        }
        return new XPathExpressionImpl(peer);
    }

    long getPeer() {
        return this.peer;
    }

    public boolean equals(Object that) {
        return that instanceof XPathExpressionImpl && this.peer == ((XPathExpressionImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    static long getPeer(XPathExpression arg) {
        return arg == null ? 0L : ((XPathExpressionImpl)arg).getPeer();
    }

    private static native void dispose(long var0);

    static XPathExpression getImpl(long peer) {
        return XPathExpressionImpl.create(peer);
    }

    @Override
    public Object evaluate(Node contextNode, short type, Object result) throws DOMException {
        return this.evaluate(contextNode, type, (XPathResult)result);
    }

    public XPathResult evaluate(Node contextNode, short type, XPathResult inResult) throws DOMException {
        return XPathResultImpl.getImpl(XPathExpressionImpl.evaluateImpl(this.getPeer(), NodeImpl.getPeer(contextNode), type, XPathResultImpl.getPeer(inResult)));
    }

    static native long evaluateImpl(long var0, long var2, short var4, long var5);

    private static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            XPathExpressionImpl.dispose(this.peer);
        }
    }
}

