/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import com.sun.javafx.collections.SetListenerHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;

public class ObservableSetWrapper<E>
implements ObservableSet<E> {
    private final Set<E> backingSet;
    private SetListenerHelper<E> listenerHelper;

    public ObservableSetWrapper(Set<E> set) {
        this.backingSet = set;
    }

    private void callObservers(SetChangeListener.Change<E> change) {
        SetListenerHelper.fireValueChangedEvent(this.listenerHelper, change);
    }

    @Override
    public void addListener(InvalidationListener listener) {
        this.listenerHelper = SetListenerHelper.addListener(this.listenerHelper, listener);
    }

    @Override
    public void removeListener(InvalidationListener listener) {
        this.listenerHelper = SetListenerHelper.removeListener(this.listenerHelper, listener);
    }

    @Override
    public void addListener(SetChangeListener<? super E> observer) {
        this.listenerHelper = SetListenerHelper.addListener(this.listenerHelper, observer);
    }

    @Override
    public void removeListener(SetChangeListener<? super E> observer) {
        this.listenerHelper = SetListenerHelper.removeListener(this.listenerHelper, observer);
    }

    @Override
    public int size() {
        return this.backingSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.backingSet.contains(o);
    }

    @Override
    public Iterator iterator() {
        return new Iterator<E>(){
            private final Iterator<E> backingIt;
            private E lastElement;
            {
                this.backingIt = ObservableSetWrapper.this.backingSet.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.backingIt.hasNext();
            }

            @Override
            public E next() {
                this.lastElement = this.backingIt.next();
                return this.lastElement;
            }

            @Override
            public void remove() {
                this.backingIt.remove();
                ObservableSetWrapper.this.callObservers(new SimpleRemoveChange(this.lastElement));
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.backingSet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.backingSet.toArray(a);
    }

    @Override
    public boolean add(E o) {
        boolean ret = this.backingSet.add(o);
        if (ret) {
            this.callObservers(new SimpleAddChange(o));
        }
        return ret;
    }

    @Override
    public boolean remove(Object o) {
        boolean ret = this.backingSet.remove(o);
        if (ret) {
            this.callObservers(new SimpleRemoveChange(o));
        }
        return ret;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.backingSet.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean ret = false;
        for (E element : c) {
            ret |= this.add(element);
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.removeRetain(c, false);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.removeRetain(c, true);
    }

    private boolean removeRetain(Collection<?> c, boolean remove) {
        boolean removed = false;
        Iterator<E> i = this.backingSet.iterator();
        while (i.hasNext()) {
            E element = i.next();
            if (remove != c.contains(element)) continue;
            removed = true;
            i.remove();
            this.callObservers(new SimpleRemoveChange(element));
        }
        return removed;
    }

    @Override
    public void clear() {
        Iterator<E> i = this.backingSet.iterator();
        while (i.hasNext()) {
            E element = i.next();
            i.remove();
            this.callObservers(new SimpleRemoveChange(element));
        }
    }

    public String toString() {
        return this.backingSet.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return this.backingSet.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.backingSet.hashCode();
    }

    private class SimpleRemoveChange
    extends SetChangeListener.Change<E> {
        private final E removed;

        public SimpleRemoveChange(E removed) {
            super(ObservableSetWrapper.this);
            this.removed = removed;
        }

        @Override
        public boolean wasAdded() {
            return false;
        }

        @Override
        public boolean wasRemoved() {
            return true;
        }

        @Override
        public E getElementAdded() {
            return null;
        }

        @Override
        public E getElementRemoved() {
            return this.removed;
        }

        public String toString() {
            return "removed " + this.removed;
        }
    }

    private class SimpleAddChange
    extends SetChangeListener.Change<E> {
        private final E added;

        public SimpleAddChange(E added) {
            super(ObservableSetWrapper.this);
            this.added = added;
        }

        @Override
        public boolean wasAdded() {
            return true;
        }

        @Override
        public boolean wasRemoved() {
            return false;
        }

        @Override
        public E getElementAdded() {
            return this.added;
        }

        @Override
        public E getElementRemoved() {
            return null;
        }

        public String toString() {
            return "added " + this.added;
        }
    }
}

