/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.menu.CheckMenuItemBase;
import com.sun.javafx.menu.CustomMenuItemBase;
import com.sun.javafx.menu.MenuBase;
import com.sun.javafx.menu.MenuItemBase;
import com.sun.javafx.menu.RadioMenuItemBase;
import com.sun.javafx.menu.SeparatorMenuItemBase;
import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;

public class GlobalMenuAdapter
extends Menu
implements MenuBase {
    private Menu menu;
    private final ObservableList<MenuItemBase> items = new TrackableObservableList<MenuItemBase>(){

        @Override
        protected void onChanged(ListChangeListener.Change<MenuItemBase> c) {
        }
    };

    public static MenuBase adapt(Menu menu) {
        return new GlobalMenuAdapter(menu);
    }

    private GlobalMenuAdapter(Menu menu) {
        super(menu.getText());
        this.menu = menu;
        GlobalMenuAdapter.bindMenuItemProperties(this, menu);
        menu.showingProperty().addListener(property -> {
            if (menu.isShowing() && !this.isShowing()) {
                this.show();
            } else if (!menu.isShowing() && this.isShowing()) {
                this.hide();
            }
        });
        this.showingProperty().addListener(property -> {
            if (this.isShowing() && !menu.isShowing()) {
                menu.show();
            } else if (!this.isShowing() && menu.isShowing()) {
                menu.hide();
            }
        });
        menu.getItems().addListener(new ListChangeListener<MenuItem>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends MenuItem> change) {
                while (change.next()) {
                    int i;
                    int from = change.getFrom();
                    int to = change.getTo();
                    List<? extends MenuItem> removed = change.getRemoved();
                    for (i = from + removed.size() - 1; i >= from; --i) {
                        GlobalMenuAdapter.this.items.remove(i);
                        GlobalMenuAdapter.this.getItems().remove(i);
                    }
                    for (i = from; i < to; ++i) {
                        MenuItem item = (MenuItem)change.getList().get(i);
                        GlobalMenuAdapter.this.insertItem(item, i);
                    }
                }
            }
        });
        for (MenuItem menuItem : menu.getItems()) {
            this.insertItem(menuItem, this.items.size());
        }
    }

    private void insertItem(MenuItem menuItem, int pos) {
        MenuItem mib = menuItem instanceof Menu ? new GlobalMenuAdapter((Menu)menuItem) : (menuItem instanceof CheckMenuItem ? new CheckMenuItemAdapter((CheckMenuItem)menuItem) : (menuItem instanceof RadioMenuItem ? new RadioMenuItemAdapter((RadioMenuItem)menuItem) : (menuItem instanceof SeparatorMenuItem ? new SeparatorMenuItemAdapter((SeparatorMenuItem)menuItem) : (menuItem instanceof CustomMenuItem ? new CustomMenuItemAdapter((CustomMenuItem)menuItem) : new MenuItemAdapter(menuItem)))));
        this.items.add(pos, (MenuItemBase)((Object)mib));
        this.getItems().add(pos, mib);
    }

    @Override
    public final ObservableList<MenuItemBase> getItemsBase() {
        return this.items;
    }

    private static void bindMenuItemProperties(MenuItem adapter, MenuItem menuItem) {
        adapter.idProperty().bind(menuItem.idProperty());
        adapter.textProperty().bind(menuItem.textProperty());
        adapter.graphicProperty().bind(menuItem.graphicProperty());
        adapter.disableProperty().bind(menuItem.disableProperty());
        adapter.visibleProperty().bind(menuItem.visibleProperty());
        adapter.acceleratorProperty().bind(menuItem.acceleratorProperty());
        adapter.mnemonicParsingProperty().bind(menuItem.mnemonicParsingProperty());
        adapter.setOnAction(ev -> menuItem.fire());
    }

    @Override
    public void fireValidation() {
        Menu target;
        if (this.menu.getOnMenuValidation() != null) {
            Event.fireEvent(this.menu, new Event(MENU_VALIDATION_EVENT));
        }
        if ((target = this.menu.getParentMenu()) != null && target.getOnMenuValidation() != null) {
            Event.fireEvent(target, new Event(MenuItem.MENU_VALIDATION_EVENT));
        }
    }

    private static class CustomMenuItemAdapter
    extends CustomMenuItem
    implements CustomMenuItemBase {
        private CustomMenuItem menuItem;

        private CustomMenuItemAdapter(CustomMenuItem menuItem) {
            this.menuItem = menuItem;
            GlobalMenuAdapter.bindMenuItemProperties(this, menuItem);
        }

        @Override
        public void fireValidation() {
            Menu target;
            if (this.getOnMenuValidation() != null) {
                Event.fireEvent(this.menuItem, new Event(MENU_VALIDATION_EVENT));
            }
            if ((target = this.menuItem.getParentMenu()).getOnMenuValidation() != null) {
                Event.fireEvent(target, new Event(MenuItem.MENU_VALIDATION_EVENT));
            }
        }
    }

    private static class SeparatorMenuItemAdapter
    extends SeparatorMenuItem
    implements SeparatorMenuItemBase {
        private SeparatorMenuItem menuItem;

        private SeparatorMenuItemAdapter(SeparatorMenuItem menuItem) {
            this.menuItem = menuItem;
            GlobalMenuAdapter.bindMenuItemProperties(this, menuItem);
        }

        @Override
        public void fireValidation() {
            Menu target;
            if (this.getOnMenuValidation() != null) {
                Event.fireEvent(this.menuItem, new Event(MENU_VALIDATION_EVENT));
            }
            if ((target = this.menuItem.getParentMenu()).getOnMenuValidation() != null) {
                Event.fireEvent(target, new Event(MenuItem.MENU_VALIDATION_EVENT));
            }
        }
    }

    private static class RadioMenuItemAdapter
    extends RadioMenuItem
    implements RadioMenuItemBase {
        private RadioMenuItem menuItem;

        private RadioMenuItemAdapter(RadioMenuItem menuItem) {
            super(menuItem.getText());
            this.menuItem = menuItem;
            GlobalMenuAdapter.bindMenuItemProperties(this, menuItem);
            this.selectedProperty().bindBidirectional(menuItem.selectedProperty());
        }

        @Override
        public void fireValidation() {
            Menu target;
            if (this.getOnMenuValidation() != null) {
                Event.fireEvent(this.menuItem, new Event(MENU_VALIDATION_EVENT));
            }
            if ((target = this.menuItem.getParentMenu()).getOnMenuValidation() != null) {
                Event.fireEvent(target, new Event(MenuItem.MENU_VALIDATION_EVENT));
            }
        }
    }

    private static class CheckMenuItemAdapter
    extends CheckMenuItem
    implements CheckMenuItemBase {
        private CheckMenuItem menuItem;

        private CheckMenuItemAdapter(CheckMenuItem menuItem) {
            super(menuItem.getText());
            this.menuItem = menuItem;
            GlobalMenuAdapter.bindMenuItemProperties(this, menuItem);
            this.selectedProperty().bindBidirectional(menuItem.selectedProperty());
        }

        @Override
        public void fireValidation() {
            Menu target;
            if (this.getOnMenuValidation() != null) {
                Event.fireEvent(this.menuItem, new Event(MENU_VALIDATION_EVENT));
            }
            if ((target = this.menuItem.getParentMenu()).getOnMenuValidation() != null) {
                Event.fireEvent(target, new Event(MenuItem.MENU_VALIDATION_EVENT));
            }
        }
    }

    private static class MenuItemAdapter
    extends MenuItem
    implements MenuItemBase {
        private MenuItem menuItem;

        private MenuItemAdapter(MenuItem menuItem) {
            super(menuItem.getText());
            this.menuItem = menuItem;
            GlobalMenuAdapter.bindMenuItemProperties(this, menuItem);
        }

        @Override
        public void fireValidation() {
            Menu target;
            if (this.menuItem.getOnMenuValidation() != null) {
                Event.fireEvent(this.menuItem, new Event(MenuItem.MENU_VALIDATION_EVENT));
            }
            if ((target = this.menuItem.getParentMenu()).getOnMenuValidation() != null) {
                Event.fireEvent(target, new Event(MenuItem.MENU_VALIDATION_EVENT));
            }
        }
    }
}

