/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.ButtonBehavior;
import com.sun.javafx.scene.control.skin.LabeledSkinBase;
import com.sun.javafx.scene.control.skin.Utils;
import javafx.geometry.NodeOrientation;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.StackPane;

public class CheckBoxSkin
extends LabeledSkinBase<CheckBox, ButtonBehavior<CheckBox>> {
    private final StackPane box = new StackPane();
    private StackPane innerbox;

    public CheckBoxSkin(CheckBox checkbox) {
        super(checkbox, new ButtonBehavior<CheckBox>(checkbox));
        this.box.getStyleClass().setAll((String[])new String[]{"box"});
        this.innerbox = new StackPane();
        this.innerbox.getStyleClass().setAll((String[])new String[]{"mark"});
        this.innerbox.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        this.box.getChildren().add(this.innerbox);
        this.updateChildren();
    }

    @Override
    protected void updateChildren() {
        super.updateChildren();
        if (this.box != null) {
            this.getChildren().add(this.box);
        }
    }

    @Override
    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computeMinWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSize(this.box.minWidth(-1.0));
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Math.max(super.computeMinHeight(width - this.box.minWidth(-1.0), topInset, rightInset, bottomInset, leftInset), topInset + this.box.minHeight(-1.0) + bottomInset);
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSize(this.box.prefWidth(-1.0));
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Math.max(super.computePrefHeight(width - this.box.prefWidth(-1.0), topInset, rightInset, bottomInset, leftInset), topInset + this.box.prefHeight(-1.0) + bottomInset);
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        CheckBox checkBox = (CheckBox)this.getSkinnable();
        double boxWidth = this.snapSize(this.box.prefWidth(-1.0));
        double boxHeight = this.snapSize(this.box.prefHeight(-1.0));
        double computeWidth = Math.max(checkBox.prefWidth(-1.0), checkBox.minWidth(-1.0));
        double labelWidth = Math.min(computeWidth - boxWidth, w - this.snapSize(boxWidth));
        double labelHeight = Math.min(checkBox.prefHeight(labelWidth), h);
        double maxHeight = Math.max(boxHeight, labelHeight);
        double xOffset = Utils.computeXOffset(w, labelWidth + boxWidth, checkBox.getAlignment().getHpos()) + x;
        double yOffset = Utils.computeYOffset(h, maxHeight, checkBox.getAlignment().getVpos()) + x;
        this.layoutLabelInArea(xOffset + boxWidth, yOffset, labelWidth, maxHeight, checkBox.getAlignment());
        this.box.resize(boxWidth, boxHeight);
        this.positionInArea(this.box, xOffset, yOffset, boxWidth, maxHeight, 0.0, checkBox.getAlignment().getHpos(), checkBox.getAlignment().getVpos());
    }
}

