/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.tk.quantum.ViewScene;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.PauseTransition;
import javafx.animation.SequentialTransition;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;

public class OverlayWarning
extends Group {
    private static final float PAD = 40.0f;
    private static final float RECTW = 600.0f;
    private static final float RECTH = 100.0f;
    private static final float ARC = 20.0f;
    private static final int FONTSIZE = 24;
    private ViewScene view;
    private SequentialTransition overlayTransition;
    private boolean warningTransition;
    private Text text = new Text();
    private Rectangle background;

    public OverlayWarning(ViewScene vs) {
        this.view = vs;
        this.createOverlayGroup();
        PauseTransition pause = new PauseTransition(Duration.millis(4000.0));
        FadeTransition fade = new FadeTransition(Duration.millis(1000.0), this);
        fade.setFromValue(1.0);
        fade.setToValue(0.0);
        this.overlayTransition = new SequentialTransition();
        this.overlayTransition.getChildren().add(pause);
        this.overlayTransition.getChildren().add(fade);
        this.overlayTransition.setOnFinished(event -> {
            this.warningTransition = false;
            this.view.getWindowStage().setWarning(null);
        });
    }

    protected ViewScene getView() {
        return this.view;
    }

    protected final void setView(ViewScene vs) {
        if (this.view != null) {
            this.view.getWindowStage().setWarning(null);
        }
        this.view = vs;
        this.view.entireSceneNeedsRepaint();
    }

    protected void warn(String msg) {
        this.text.setText(msg);
        this.warningTransition = true;
        this.overlayTransition.play();
    }

    protected void cancel() {
        if (this.overlayTransition != null && this.overlayTransition.getStatus() == Animation.Status.RUNNING) {
            this.overlayTransition.stop();
            this.warningTransition = false;
        }
        this.view.getWindowStage().setWarning(null);
    }

    protected boolean inWarningTransition() {
        return this.warningTransition;
    }

    private void createOverlayGroup() {
        Font font = new Font(Font.getDefault().getFamily(), 24.0);
        Rectangle2D screenBounds = new Rectangle2D(0.0, 0.0, this.view.getSceneState().getScreenWidth(), this.view.getSceneState().getScreenHeight());
        String TEXT_CSS = "-fx-effect: dropshadow(two-pass-box, rgba(0,0,0,0.75), 3, 0.0, 0, 2);";
        this.text.setStroke(Color.WHITE);
        this.text.setFill(Color.WHITE);
        this.text.setFont(font);
        this.text.setWrappingWidth(520.0);
        this.text.setStyle(TEXT_CSS);
        this.text.setTextAlignment(TextAlignment.CENTER);
        this.background = this.createBackground(this.text, screenBounds);
        this.getChildren().add(this.background);
        this.getChildren().add(this.text);
    }

    private Rectangle createBackground(Text text, Rectangle2D screen) {
        Rectangle rectangle = new Rectangle();
        double textW = text.getLayoutBounds().getWidth();
        double textH = text.getLayoutBounds().getHeight();
        double rectX = (screen.getWidth() - 600.0) / 2.0;
        double rectY = screen.getHeight() / 2.0;
        rectangle.setWidth(600.0);
        rectangle.setHeight(100.0);
        rectangle.setX(rectX);
        rectangle.setY(rectY - 100.0);
        rectangle.setArcWidth(20.0);
        rectangle.setArcHeight(20.0);
        rectangle.setFill(Color.gray(0.0, 0.6));
        text.setX(rectX + (600.0 - textW) / 2.0);
        text.setY(rectY - 50.0 + (textH - text.getBaselineOffset()) / 2.0);
        return rectangle;
    }

    @Override
    public void impl_updatePeer() {
        this.text.impl_updatePeer();
        this.background.impl_updatePeer();
        super.impl_updatePeer();
    }

    @Override
    protected void updateBounds() {
        super.updateBounds();
    }

    @Override
    protected void impl_markDirty(DirtyBits dirtyBit) {
        super.impl_markDirty(dirtyBit);
        this.view.synchroniseOverlayWarning();
    }
}

