/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d;

import com.sun.prism.d3d.D3DContext;
import com.sun.prism.impl.BaseMesh;
import com.sun.prism.impl.Disposer;

class D3DMesh
extends BaseMesh {
    static int count = 0;
    private final D3DContext context;
    private final long nativeHandle;

    private D3DMesh(D3DContext context, long nativeHandle, Disposer.Record disposerRecord) {
        super(disposerRecord);
        this.context = context;
        this.nativeHandle = nativeHandle;
        ++count;
    }

    static D3DMesh create(D3DContext context) {
        long nativeHandle = context.createD3DMesh();
        return new D3DMesh(context, nativeHandle, new D3DMeshDisposerRecord(context, nativeHandle));
    }

    long getNativeHandle() {
        return this.nativeHandle;
    }

    @Override
    public boolean isValid() {
        return !this.context.isDisposed();
    }

    @Override
    public void dispose() {
        this.disposerRecord.dispose();
        --count;
    }

    @Override
    public int getCount() {
        return count;
    }

    @Override
    public boolean buildNativeGeometry(float[] vertexBuffer, int vertexBufferLength, int[] indexBufferInt, int indexBufferLength) {
        return this.context.buildNativeGeometry(this.nativeHandle, vertexBuffer, vertexBufferLength, indexBufferInt, indexBufferLength);
    }

    @Override
    public boolean buildNativeGeometry(float[] vertexBuffer, int vertexBufferLength, short[] indexBufferShort, int indexBufferLength) {
        return this.context.buildNativeGeometry(this.nativeHandle, vertexBuffer, vertexBufferLength, indexBufferShort, indexBufferLength);
    }

    static class D3DMeshDisposerRecord
    implements Disposer.Record {
        private final D3DContext context;
        private long nativeHandle;

        D3DMeshDisposerRecord(D3DContext context, long nativeHandle) {
            this.context = context;
            this.nativeHandle = nativeHandle;
        }

        void traceDispose() {
        }

        @Override
        public void dispose() {
            if (this.nativeHandle != 0L) {
                this.traceDispose();
                this.context.releaseD3DMesh(this.nativeHandle);
                this.nativeHandle = 0L;
            }
        }
    }
}

