/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d;

import com.sun.prism.MediaFrame;
import com.sun.prism.PixelFormat;
import com.sun.prism.Texture;
import com.sun.prism.d3d.D3DContext;
import com.sun.prism.d3d.D3DContextSource;
import com.sun.prism.d3d.D3DResourceFactory;
import com.sun.prism.d3d.D3DTextureData;
import com.sun.prism.d3d.D3DTextureResource;
import com.sun.prism.impl.BaseTexture;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

class D3DTexture
extends BaseTexture<D3DTextureResource>
implements D3DContextSource {
    D3DTexture(D3DContext context, PixelFormat format, Texture.WrapMode wrapMode, long pResource, int physicalWidth, int physicalHeight, int contentWidth, int contentHeight, boolean isRTT) {
        this(context, format, wrapMode, pResource, physicalWidth, physicalHeight, 0, 0, contentWidth, contentHeight, isRTT, 0, false);
    }

    D3DTexture(D3DContext context, PixelFormat format, Texture.WrapMode wrapMode, long pResource, int physicalWidth, int physicalHeight, int contentX, int contentY, int contentWidth, int contentHeight, boolean isRTT, int samples, boolean useMipmap) {
        super(new D3DTextureResource(new D3DTextureData(context, pResource, isRTT, physicalWidth, physicalHeight, format, samples)), format, wrapMode, physicalWidth, physicalHeight, contentX, contentY, contentWidth, contentHeight, physicalWidth, physicalHeight, useMipmap);
    }

    D3DTexture(D3DTexture sharedTex, Texture.WrapMode altMode) {
        super(sharedTex, altMode, false);
    }

    @Override
    protected Texture createSharedTexture(Texture.WrapMode newMode) {
        return new D3DTexture(this, newMode);
    }

    public long getNativeSourceHandle() {
        return ((D3DTextureData)((D3DTextureResource)this.resource).getResource()).getResource();
    }

    public long getNativeTextureObject() {
        return D3DResourceFactory.nGetNativeTextureObject(this.getNativeSourceHandle());
    }

    @Override
    public D3DContext getContext() {
        return ((D3DTextureData)((D3DTextureResource)this.resource).getResource()).getContext();
    }

    @Override
    public void update(MediaFrame frame, boolean skipFlush) {
        PixelFormat targetFormat;
        if (frame.getPixelFormat() == PixelFormat.MULTI_YCbCr_420) {
            throw new IllegalArgumentException("Unsupported format " + (Object)((Object)frame.getPixelFormat()));
        }
        frame.holdFrame();
        ByteBuffer pixels = frame.getBufferForPlane(0);
        D3DContext ctx = this.getContext();
        if (!skipFlush) {
            ctx.flushVertexBuffer();
        }
        int result = (targetFormat = frame.getPixelFormat()).getDataType() == PixelFormat.DataType.INT ? D3DResourceFactory.nUpdateTextureI(ctx.getContextHandle(), this.getNativeSourceHandle(), pixels.asIntBuffer(), null, 0, 0, 0, 0, frame.getEncodedWidth(), frame.getEncodedHeight(), frame.strideForPlane(0)) : D3DResourceFactory.nUpdateTextureB(ctx.getContextHandle(), this.getNativeSourceHandle(), pixels, null, targetFormat.ordinal(), 0, 0, 0, 0, frame.getEncodedWidth(), frame.getEncodedHeight(), frame.strideForPlane(0));
        D3DContext.validate(result);
        frame.releaseFrame();
    }

    @Override
    public void update(Buffer pixels, PixelFormat format, int dstx, int dsty, int srcx, int srcy, int srcw, int srch, int srcscan, boolean skipFlush) {
        this.checkUpdateParams(pixels, format, dstx, dsty, srcx, srcy, srcw, srch, srcscan);
        if (!skipFlush) {
            this.getContext().flushVertexBuffer();
        }
        int contentX = this.getContentX();
        int contentY = this.getContentY();
        int contentW = this.getContentWidth();
        int contentH = this.getContentHeight();
        int texWidth = this.getPhysicalWidth();
        int texHeight = this.getPhysicalHeight();
        this.update(pixels, format, contentX + dstx, contentY + dsty, srcx, srcy, srcw, srch, srcscan);
        switch (this.getWrapMode()) {
            case CLAMP_TO_EDGE: {
                break;
            }
            case CLAMP_TO_EDGE_SIMULATED: {
                boolean copyL;
                boolean copyR = contentW < texWidth && dstx + srcw == contentW;
                boolean bl = copyL = contentH < texHeight && dsty + srch == contentH;
                if (copyR) {
                    this.update(pixels, format, contentX + contentW, contentY + dsty, srcx + srcw - 1, srcy, 1, srch, srcscan);
                }
                if (!copyL) break;
                this.update(pixels, format, contentX + dstx, contentY + contentH, srcx, srcy + srch - 1, srcw, 1, srcscan);
                if (!copyR) break;
                this.update(pixels, format, contentX + contentW, contentY + contentH, srcx + srcw - 1, srcy + srch - 1, 1, 1, srcscan);
                break;
            }
            case REPEAT: {
                break;
            }
            case REPEAT_SIMULATED: {
                boolean repeatT;
                boolean repeatL = contentW < texWidth && dstx == 0;
                boolean bl = repeatT = contentH < texHeight && dsty == 0;
                if (repeatL) {
                    this.update(pixels, format, contentX + contentW, contentY + dsty, srcx, srcy, 1, srch, srcscan);
                }
                if (!repeatT) break;
                this.update(pixels, format, contentX + dstx, contentY + contentH, srcx, srcy, srcw, 1, srcscan);
                if (!repeatL) break;
                this.update(pixels, format, contentX + contentW, contentY + contentH, srcx, srcy, 1, 1, srcscan);
                break;
            }
        }
    }

    public void update(Buffer pixels, PixelFormat format, int dstx, int dsty, int srcx, int srcy, int srcw, int srch, int srcscan) {
        int res;
        D3DContext ctx = this.getContext();
        if (format.getDataType() == PixelFormat.DataType.INT) {
            IntBuffer buf = (IntBuffer)pixels;
            int[] arr = buf.hasArray() ? buf.array() : null;
            res = D3DResourceFactory.nUpdateTextureI(ctx.getContextHandle(), this.getNativeSourceHandle(), buf, arr, dstx, dsty, srcx, srcy, srcw, srch, srcscan);
        } else if (format.getDataType() == PixelFormat.DataType.FLOAT) {
            FloatBuffer buf = (FloatBuffer)pixels;
            float[] arr = buf.hasArray() ? buf.array() : null;
            res = D3DResourceFactory.nUpdateTextureF(ctx.getContextHandle(), this.getNativeSourceHandle(), buf, arr, dstx, dsty, srcx, srcy, srcw, srch, srcscan);
        } else {
            ByteBuffer buf = (ByteBuffer)pixels;
            buf.rewind();
            byte[] arr = buf.hasArray() ? buf.array() : null;
            res = D3DResourceFactory.nUpdateTextureB(ctx.getContextHandle(), this.getNativeSourceHandle(), buf, arr, format.ordinal(), dstx, dsty, srcx, srcy, srcw, srch, srcscan);
        }
        D3DContext.validate(res);
    }
}

